from CvPythonExtensions import *
import CvUtil
import PyHelpers
import Popup as PyPopup
import CvCustomEventManager

PyInfo = PyHelpers.PyInfo
			
# globals
gc = CyGlobalContext()
grass = 25
plains = 26
desert = 27
snow =  28
peak = 29
raiseelev = 30
lowerelev = 31
land = 32
jungle = 33
forest = 34

class Terraform:
	def __init__(self):
		self.list = []
		self.pPlot = CyMap().plot(0,0)

	def onImprovementBuilt(self, argsList):
		'Improvement Built'
		iImprovement, iX, iY = argsList
		pPlot = CyMap().plot(iX,iY)
		if(iImprovement==grass):
			pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_GRASS"), true, true)
			pPlot.setImprovementType(-1)
		elif(iImprovement==plains):
			if(pPlot.getTerrainType()==gc.getInfoTypeForString("TERRAIN_SNOW")):
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_TUNDRA"), true, true)
			else:
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"), true, true)
			pPlot.setImprovementType(-1)
		elif(iImprovement==desert):
			pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_DESERT"), true, true)
			if((pPlot.isRiverSide()==1) and (pPlot.getPlotType()==PlotTypes.PLOT_LAND)):
				pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS"), 0)
			pPlot.setImprovementType(-1)
		elif(iImprovement==snow):
			if(pPlot.getTerrainType()==gc.getInfoTypeForString("TERRAIN_TUNDRA")):
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_SNOW"), true, true)
			else:
				pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_TUNDRA"), true, true)
			pPlot.setImprovementType(-1)
		elif(iImprovement==peak):
			pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PEAK"), true, true)
			pPlot.setImprovementType(-1)
		elif(iImprovement==raiseelev):
			if(pPlot.getPlotType()==PlotTypes.PLOT_LAND):
				pPlot.setPlotType(PlotTypes.PLOT_HILLS, true, true)
				if(pPlot.getFeatureType()==gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS")):
					pPlot.setFeatureType(-1,0)
			else:
				pPlot.setPlotType(PlotTypes.PLOT_PEAK, true, true)
				pPlot.setRouteType(-1)
			pPlot.setImprovementType(-1)
		elif(iImprovement==lowerelev):
			if(pPlot.getPlotType()==PlotTypes.PLOT_LAND):
				numberofunits = pPlot.getNumUnits()
				while(numberofunits > 0):
					pPlot.getUnit(0).jumpToNearestValidPlot()
					numberofunits = pPlot.getNumUnits()
				pPlot.setPlotType(PlotTypes.PLOT_OCEAN, true, true)
			else:
				pPlot.setPlotType(PlotTypes.PLOT_LAND, true, true)
				if(pPlot.getTerrainType()==gc.getInfoTypeForString("TERRAIN_DESERT") and pPlot.isRiver()):
                                        pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_FLOOD_PLAINS"), 0)
			pPlot.setImprovementType(-1)
		elif(iImprovement==land):
                        pPlot.setImprovementType(-1)
			pPlot = CyMap().plot(iX-1,iY-1)
			if(pPlot.isWater()==1):
				self.list.append("SouthWest(1)")
			pPlot = CyMap().plot(iX,iY-1)
			if(pPlot.isWater()==1):
				self.list.append("South(2)")
			pPlot = CyMap().plot(iX+1,iY-1)
			if(pPlot.isWater()==1):
				self.list.append("SouthEast(3)")
			pPlot = CyMap().plot(iX-1,iY)
			if(pPlot.isWater()==1):
				self.list.append("West(4)")
			pPlot = CyMap().plot(iX+1,iY)
			if(pPlot.isWater()==1):
				self.list.append("East(6)")
			pPlot = CyMap().plot(iX-1,iY+1)
			if(pPlot.isWater()==1):
				self.list.append("NorthWest(7)")
			pPlot = CyMap().plot(iX,iY+1)
			if(pPlot.isWater()==1):
				self.list.append("North(8)")
			pPlot = CyMap().plot(iX+1,iY+1)
			if(pPlot.isWater()==1):
				self.list.append("NorthEast(9)")
			if(len(self.list) > 0):
				self.pPlot = CyMap().plot(iX,iY)
				CvCustomEventManager.CvCustomEventManager().beginEvent(7502)
		elif(iImprovement==jungle):
			pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_JUNGLE"), 1)
			pPlot.setImprovementType(-1)
		elif(iImprovement==forest):
			pPlot.setFeatureType(gc.getInfoTypeForString("FEATURE_FOREST"), 1)
			pPlot.setImprovementType(-1)

		CvUtil.pyPrint('Improvement %s was built at %d, %d'
			%(PyInfo.ImprovementInfo(iImprovement).getDescription(), iX, iY))

	def onRouteBuilt(self, argsList):
                'Route Built'
                iRoute, iX, iY = argsList
                pPlot = CyMap().plot(iX,iY)
		if(pPlot.getPlotType()==PlotTypes.PLOT_PEAK):
                        pPlot.setPlotType(PlotTypes.PLOT_HILLS, true, true)
                        pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PEAK"), true, true)
                        pPlot.setFeatureType(-1,0)
                CvUtil.pyPrint('Route %s was built at %d, %d' %(gc.getRouteInfo(iRoute).getDescription(), iX, iY))
                    
	def eventRemoveWaterBegin(self, argsList):
		popup = PyPopup.PyPopup(7502, EventContextTypes.EVENTCONTEXT_ALL)
		popup.setHeaderString("What water would you like to make land?")
	    	popup.createPullDown()
		for i in range(0 , len(self.list)):
		     	popup.addPullDownString(self.list[i] , i)
		popup.addButton("Ok")
                CyCamera().JustLookAtPlot(self.pPlot)
		popup.launch(False, PopupStates.POPUPSTATE_IMMEDIATE)
		return

	def eventRemoveWaterApply(self, playerID, userData, popupReturn):
		if (popupReturn.getButtonClicked() == 0):
			direction = self.list[popupReturn.getSelectedPullDownValue(0)]
			ix = self.pPlot.getX()
			iy = self.pPlot.getY()
			if((direction == "SouthWest(1)") or (direction == "West(4)") or (direction == "NorthWest(7)")):
				ix = ix - 1
			if((direction == "SouthEast(3)") or (direction == "East(6)") or (direction == "NorthEast(9)")):
				ix = ix + 1
			if((direction == "SouthWest(1)") or (direction == "South(2)") or (direction == "SouthEast(3)")):
				iy = iy - 1
			if((direction == "NorthWest(7)") or (direction == "North(8)") or (direction == "NorthEast(9)")):
				iy = iy + 1
                        self.pPlot = CyMap().plot(ix,iy)
			self.pPlot.setPlotType(PlotTypes.PLOT_LAND, true, true)
			self.pPlot.setTerrainType(gc.getInfoTypeForString("TERRAIN_PLAINS"), true, true)
			self.list = []
		return
